<?php
/**
*
* common [French]
*
* @package language
* @version $Id: common.php 8555 2008-05-15 14:10:11Z Kellanved $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

//
// TRANSLATION DETAILS
//
// Author: Xaphos (Maël Soucaze)
// Website: http://www.phpbb.fr/
//
// TRANSLATION LICENSE
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see http://opensource.org/licenses/gpl-license.php.
//
// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” … É À
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Translated by <a href="http://www.phpbb.fr/">phpBB.fr</a> &copy; 2007, 2008 <a href="http://www.phpbb.fr/">phpBB.fr</a>',	// You can delete this line to remove the visible copyright of the translation, but the copyright localized in the files MUST BE preserved, according the General Public License!
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'fr',

	'1_DAY'			=> '1 jour',
	'1_MONTH'		=> '1 mois',
	'1_YEAR'		=> '1 an',
	'2_WEEKS'		=> '2 semaines',
	'3_MONTHS'		=> '3 mois',
	'6_MONTHS'		=> '6 mois',
	'7_DAYS'		=> '7 jours',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Votre compte a déjà été activé.',
	'ACCOUNT_DEACTIVATED'			=> 'Votre compte a été désactivé manuellement et ne peut être réactivé que par un administrateur.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Votre compte n’a pas encore été activé.',
	'ACP'							=> 'Panneau de contrôle de l’administrateur',
	'ACTIVE'						=> 'actif',
	'ACTIVE_ERROR'					=> 'Le nom d’utilisateur que vous avez spécifié est actuellement inactif. Si vous continuez à rencontrer des problèmes lors de l’activation de votre compte, veuillez contacter un administrateur du forum.',
	'ADMINISTRATOR'					=> 'Administrateur',
	'ADMINISTRATORS'				=> 'Administrateurs',
	'AGE'							=> 'Âge',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Autorisé',
	'ALL_FILES'						=> 'Tous les fichiers',
	'ALL_FORUMS'					=> 'Tous les forums',
	'ALL_MESSAGES'					=> 'Tous les messages',
	'ALL_POSTS'						=> 'Tous les messages',
	'ALL_TIMES'						=> 'Heures au format %1$s %2$s',
	'ALL_TOPICS'					=> 'Tous les sujets',
	'AND'							=> 'Et',
	'ARE_WATCHING_FORUM'			=> 'Vous êtes à présent abonné afin d’être averti des nouveaux messages dans ce forum.',
	'ARE_WATCHING_TOPIC'			=> 'Vous êtes à présent abonné afin d’être averti des nouveaux messages dans ce sujet.',
	'ASCENDING'						=> 'Croissant',
	'ATTACHMENTS'					=> 'Pièces jointes',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'L’image que vous avez essayé d’insérer est incorrecte.',
	'AUTHOR'						=> 'Auteur',
	'AUTH_NO_PROFILE_CREATED'		=> 'La création d’un profil utilisateur a échouée.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Le transfert a été rejeté car le fichier transféré a été identifié comme un vecteur d’attaque possible.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Ce fichier ne peut pas s’afficher car l’extension <strong>%s</strong> est interdite.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'L’avatar que vous avez spécifié n’a pas pu être transféré car les données à distance semblent corrompues ou incorrectes.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'L’avatar que vous avez transféré est vide.',
	'AVATAR_INVALID_FILENAME'		=> 'Le nom du fichier <strong>%s</strong> est incorrect.',
	'AVATAR_NOT_UPLOADED'			=> 'Le transfert de l’avatar a échoué.',
	'AVATAR_NO_SIZE'				=> 'La largeur ou la hauteur de l’avatar lié n’a pas pu être déterminée. Veuillez les saisir manuellement.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Le fichier que vous avez spécifié n’a été que partiellement transféré.',
	'AVATAR_PHP_SIZE_NA'			=> 'La taille de l’avatar est trop importante.<br />La taille maximale autorisée par PHP, située dans le fichier <var>php.ini</var>, n’a pas pu être déterminée.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'La taille de l’avatar est trop importante, la taille maximale autorisée est de %d Mo.<br />Veuillez noter que ce réglage est situé dans le fichier <var>php.ini</var> et ne peut pas être écrasé.',
	'AVATAR_URL_INVALID'			=> 'Le lien que vous avez spécifié est incorrect.',
	'AVATAR_URL_NOT_FOUND'			=> 'Le fichier que vous avez spécifié est introuvable.',
	'AVATAR_WRONG_FILESIZE'			=> 'La taille de l’avatar doit être comprise entre 0 et %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'La taille de l’avatar que vous avez envoyé est de %5$d pixels de large et %6$d pixels de haut. Cependant, la taille des avatars doit être comprise entre %1$d pixels de large et %2$d pixels de haut mais ne doit pas dépasser %3$d pixels de large et %4$d pixels de haut.',

	'BACK_TO_TOP'			=> 'Haut',
	'BACK_TO_PREV'			=> 'Retourner à la page précédente',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Un bannissement a été mis en place sur votre adresse e-mail.',
	'BAN_TRIGGERED_BY_IP'	=> 'Un bannissement a été mis en place sur votre adresse IP.',
	'BAN_TRIGGERED_BY_USER'	=> 'Un bannissement a été mis en place sur votre nom d’utilisateur.',
	'BBCODE_GUIDE'			=> 'Guide du BBCode',
	'BCC'					=> 'Cci',
	'BIRTHDAYS'				=> 'Anniversaires',
	'BOARD_BAN_PERM'		=> 'Vous avez été banni <strong>définitivement</strong> de ce forum.<br /><br />Pour plus d’informations, veuillez contacter l’%2$sadministrateur du forum%3$s.',
	'BOARD_BAN_REASON'		=> 'Raison du bannissement : <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Vous avez été banni de ce forum jusqu’au <strong>%1$s</strong>.<br /><br />Pour plus d’informations, veuillez contacter l’%2$sadministrateur du forum%3$s.',
	'BOARD_DISABLE'			=> 'Désolé mais ce forum est actuellement indisponible.',
	'BOARD_DISABLED'		=> 'Ce forum est actuellement désactivé.',
	'BOARD_UNAVAILABLE'		=> 'Désolé mais ce forum est actuellement indisponible, veuillez réessayer dans quelques minutes.',
	'BROWSING_FORUM'		=> 'Utilisateurs parcourant actuellement ce forum : %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Utilisateurs parcourant actuellement ce forum : %1$s et %2$d invité',
	'BROWSING_FORUM_GUESTS'	=> 'Utilisateurs parcourant actuellement ce forum : %1$s et %2$d invités',
	'BYTES'					=> 'Octets',

	'CANCEL'				=> 'Annuler',
	'CHANGE'				=> 'Modifier',
	'CHANGE_FONT_SIZE'		=> 'Modifier la taille de la police',
	'CHANGING_PREFERENCES'	=> 'Modification des préférences du forum',
	'CHANGING_PROFILE'		=> 'Modification des réglages du profil',
	'CLICK_VIEW_PRIVMSG'	=> '%sAller à votre boîte de réception%s',
	'COLLAPSE_VIEW'			=> 'Réduire',
	'CLOSE_WINDOW'			=> 'Fermer la fenêtre',
	'COLOUR_SWATCH'			=> 'Palette de couleurs',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Confirmer',
	'CONFIRM_CODE'			=> 'Code de confirmation',
	'CONFIRM_CODE_EXPLAIN'	=> 'Entrez le code exactement comme il apparaît. Il n’est pas sensible à la casse et il ne peut pas y avoir de zéro.',
	'CONFIRM_CODE_WRONG'	=> 'Le code de confirmation que vous avez saisi est incorrect.',
	'CONFIRM_OPERATION'		=> 'Êtes-vous sûr de vouloir effectuer cette opération ?',
	'CONGRATULATIONS'		=> 'Félicitations à',
	'CONNECTION_FAILED'		=> 'La connexion a échouée.',
	'CONNECTION_SUCCESS'	=> 'Connecté avec succès !',
	'COOKIES_DELETED'		=> 'Tous les cookies du forum ont été supprimés avec succès.',
	'CURRENT_TIME'			=> 'Nous sommes actuellement le %s',

	'DAY'					=> 'Jour',
	'DAYS'					=> 'Jours',
	'DELETE'				=> 'Supprimer',
	'DELETE_ALL'			=> 'Tout supprimer',
	'DELETE_COOKIES'		=> 'Supprimer tous les cookies du forum',
	'DELETE_MARKED'			=> 'Supprimer la sélection',
	'DELETE_POST'			=> 'Supprimer le message',
	'DELIMITER'				=> 'Séparateur',
	'DESCENDING'			=> 'Décroissant',
	'DISABLED'				=> 'Désactivé',
	'DISPLAY'				=> 'Afficher',
	'DISPLAY_GUESTS'		=> 'Afficher les invités',
	'DISPLAY_MESSAGES'		=> 'Afficher les messages depuis',
	'DISPLAY_POSTS'			=> 'Afficher les messages depuis',
	'DISPLAY_TOPICS'		=> 'Afficher les sujets depuis',
	'DOWNLOADED'			=> 'Téléchargé',
	'DOWNLOADING_FILE'		=> 'Téléchargement du fichier',
	'DOWNLOAD_COUNT'		=> 'Téléchargé %d fois',
	'DOWNLOAD_COUNTS'		=> 'Téléchargé %d fois',
	'DOWNLOAD_COUNT_NONE'	=> 'Jamais téléchargé',
	'VIEWED_COUNT'			=> 'Consulté %d fois',
	'VIEWED_COUNTS'			=> 'Consulté %d fois',
	'VIEWED_COUNT_NONE'		=> 'Jamais consulté',

	'EDIT_POST'							=> 'Éditer le message',
	'EMAIL'								=> 'E-mail',
	'EMAIL_ADDRESS'						=> 'Adresse e-mail',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Une erreur est survenue lors de l’envoi de l’e-mail à la <strong>ligne %1$s</strong>. Réponse : %2$s.',
	'EMPTY_SUBJECT'						=> 'Vous devez spécifier un titre lors de la rédaction d’un nouveau sujet.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Vous devez spécifier un titre lors de la rédaction d’un nouveau message.',
	'ENABLED'							=> 'Activé',
	'ENCLOSURE'							=> 'Clôture',
	'ERR_CHANGING_DIRECTORY'			=> 'Une erreur est survenue lors de la modification du répertoire.',
	'ERR_CONNECTING_SERVER'				=> 'Une erreur est survenue lors de la connexion au serveur.',
	'ERR_JAB_AUTH'						=> 'Une erreur est survenue lors de l’authentification au serveur Jabber.',
	'ERR_JAB_CONNECT'					=> 'Une erreur est survenue lors de la connexion au serveur Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Le nom d’utilisateur ou le mot de passe spécifié est incorrect.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Le chemin vers phpBB que vous avez spécifié semble incorrect.',
	'EXPAND_VIEW'						=> 'Agrandir',
	'EXTENSION'							=> 'Extension',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'L’extension <strong>%s</strong> a été désactivée et ne peut plus être affichée.',

	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Foire Aux Questions',
	'FILENAME'				=> 'Nom du fichier',
	'FILESIZE'				=> 'Taille du fichier',
	'FILEDATE'				=> 'Date du fichier',
	'FILE_COMMENT'			=> 'Description du fichier',
	'FILE_NOT_FOUND'		=> 'Le fichier que vous souhaitez est introuvable.',
	'FIND_USERNAME'			=> 'Trouver un membre',
	'FOLDER'				=> 'Dossier',
	'FORGOT_PASS'			=> 'J’ai oublié mon mot de passe',
	'FORM_INVALID'			=> 'Le formulaire que vous avez envoyé est incorrect. Veuillez essayer de le renvoyer.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forums',
	'FORUMS_MARKED'			=> 'Tous les forums ont été marqués comme lus avec succès.',
	'FORUM_CAT'				=> 'Catégorie du forum',
	'FORUM_INDEX'			=> 'Index du forum',
	'FORUM_LINK'			=> 'Forum-lien',
	'FORUM_LOCATION'		=> 'Localisation du forum',
	'FORUM_LOCKED'			=> 'Forum verrouillé',
	'FORUM_RULES'			=> 'Règles du forum',
	'FORUM_RULES_LINK'		=> 'Veuillez cliquer ici afin de consulter les règles du forum',
	'FROM'					=> 'de',
	'FSOCK_DISABLED'		=> 'L’opération n’a pas pu être accomplie car la fonction <var>fsockopen</var> a été désactivée ou le serveur interrogé est introuvable.',

	'FTP_FSOCK_HOST'				=> 'Hôte FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Le serveur FTP utilisé afin de vous connecter à votre site.',
	'FTP_FSOCK_PASSWORD'			=> 'Mot de passe FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Le mot de passe de votre nom d’utilisateur FTP.',
	'FTP_FSOCK_PORT'				=> 'Port FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Le port FTP utilisé afin de vous connecter à votre serveur.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Chemin vers phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Le chemin de la racine vers votre forum phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'Temps d’attente FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'La durée de temps, en secondes, que le système attendra afin d’obtenir une réponse de votre serveur.',
	'FTP_FSOCK_USERNAME'			=> 'Nom d’utilisateur FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Le nom d’utilisateur FTP utilisé afin de vous connecter à votre serveur.',

	'FTP_HOST'					=> 'Hôte FTP',
	'FTP_HOST_EXPLAIN'			=> 'Le serveur FTP utilisé afin de vous connecter à votre site.',
	'FTP_PASSWORD'				=> 'Mot de passe FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Le mot de passe de votre nom d’utilisateur FTP.',
	'FTP_PORT'					=> 'Port FTP',
	'FTP_PORT_EXPLAIN'			=> 'Le port FTP utilisé afin de vous connecter à votre serveur.',
	'FTP_ROOT_PATH'				=> 'Chemin vers phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Le chemin de la racine vers votre forum phpBB.',
	'FTP_TIMEOUT'				=> 'Temps d’attente FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'La durée de temps, en secondes, que le système attendra afin d’obtenir une réponse de votre serveur.',
	'FTP_USERNAME'				=> 'Nom d’utilisateur FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Le nom d’utilisateur FTP utilisé afin de vous connecter à votre serveur.',

	'GENERAL_ERROR'				=> 'Erreur générale',
	'GO'						=> 'Aller',
	'GOTO_PAGE'					=> 'Aller à la page',
	'GROUP'						=> 'Groupe',
	'GROUPS'					=> 'Groupes',
	'GROUP_ERR_TYPE'			=> 'Le type du groupe spécifié est incorrect.',
	'GROUP_ERR_USERNAME'		=> 'Aucun nom de groupe n’a été spécifié.',
	'GROUP_ERR_USER_LONG'		=> 'Les noms des groupes ne doivent pas dépasser 60 caractères. Le nom du groupe que vous avez spécifié est trop long.',
	'GUEST'						=> 'Invité',
	'GUEST_USERS_ONLINE'		=> 'Il y a %d invités en ligne',
	'GUEST_USERS_TOTAL'			=> '%d invités',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Il y a 0 invité en ligne',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 invité',
	'GUEST_USER_ONLINE'			=> 'Il y a %d invité en ligne',
	'GUEST_USER_TOTAL'			=> '%d invité',
	'G_ADMINISTRATORS'			=> 'Administrateurs',
	'G_BOTS'					=> 'Robots',
	'G_GUESTS'					=> 'Invités',
	'G_REGISTERED'				=> 'Utilisateurs inscrits',
	'G_REGISTERED_COPPA'		=> 'Utilisateurs COPPA inscrits',
	'G_GLOBAL_MODERATORS'		=> 'Modérateurs globaux',

	'HIDDEN_USERS_ONLINE'		=> '%d utilisateurs invisibles en ligne',
	'HIDDEN_USERS_TOTAL'		=> '%d invisibles',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d invisibles et ',
	'HIDDEN_USERS_ZERO_ONLINE'	=> '0 utilisateur invisible en ligne',
	'HIDDEN_USERS_ZERO_TOTAL'	=> '0 invisible',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 invisible et ',
	'HIDDEN_USER_ONLINE'		=> '%d utilisateur invisible en ligne',
	'HIDDEN_USER_TOTAL'			=> '%d invisible',
	'HIDDEN_USER_TOTAL_AND'			=> '%d invisible et ',
	'HIDE_GUESTS'				=> 'Masquer les invités',
	'HIDE_ME'					=> 'Masquer mon statut en ligne lors de cette session',
	'HOURS'						=> 'Heures',
	'HOME'						=> 'Accueil',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'Statut ICQ',	
	'IF'						=> 'Si',
	'IMAGE'						=> 'Image',
	'IMAGE_FILETYPE_INVALID'	=> 'Les images de type %d pour le standard MIME %s ne sont pas supportées.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Le type de l’image ne correspond pas : l’extension %1$s était attendue mais l’extension %2$s a été fournie.',
	'IN'						=> 'dans',
	'INDEX'						=> 'Page d’index',
	'INFORMATION'				=> 'Information',
	'INTERESTS'					=> 'Loisirs',
	'INVALID_DIGEST_CHALLENGE'	=> 'Le <var>digest-challenge</var> est incorrect.',
	'INVALID_EMAIL_LOG'			=> 'L’adresse e-mail <strong>%s</strong> est éventuellement incorrecte ?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Votre adresse IP %1$s a été bloquée car elle est dans la liste noire. Pour plus d’informations, veuillez consulter <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Inscrit le',
	'JUMP_PAGE'				=> 'Entrez le numéro de la page que vous souhaitez atteindre.',
	'JUMP_TO'				=> 'Sauter vers',
	'JUMP_TO_PAGE'			=> 'Cliquez ici afin de sauter vers la page…',

	'KB'					=> 'Ko',
	'KIB'					=> 'Kio',

	'LAST_POST'							=> 'Dernier message',
	'LAST_UPDATED'						=> 'Dernière mise à jour',
	'LAST_VISIT'						=> 'Dernière visite',
	'LDAP_NO_LDAP_EXTENSION'			=> 'L’extension LDAP est indisponible.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Impossible de se connecter au serveur LDAP.',
	'LEGEND'							=> 'Légende',
	'LOCATION'							=> 'Localisation',
	'LOCK_POST'							=> 'Verrouiller le message',
	'LOCK_POST_EXPLAIN'					=> 'Empêche toute édition',
	'LOCK_TOPIC'						=> 'Verrouiller le sujet',
	'LOGIN'								=> 'Connexion',
	'LOGIN_CHECK_PM'					=> 'Se connecter afin de vérifier ses messages privés.',
	'LOGIN_CONFIRMATION'				=> 'Confirmation de connexion',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Afin d’empêcher une éventuelle usurpation de compte, vous devez saisir un code de confirmation visuelle après un certain nombre de tentatives de connexions échouées. Le code est affiché dans l’image que vous devriez voir ci-dessous. Si vous êtes visuellement déficient ou que vous éprouvez des difficultés à lire ce code correctement, veuillez contacter l’%sadministrateur du forum%s.',
	'LOGIN_ERROR_ATTEMPTS'				=> 'Vous avez dépassé le nombre maximum de tentatives de connexions autorisé. En plus de votre nom d’utilisateur et de votre mot de passe, vous devez à présent saisir le code de confirmation visuelle que vous devriez voir ci-dessous.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Vous n’avez pas été authentifié par Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'Vous avez spécifié un mot de passe incorrect. Veuillez vérifier votre mot de passe et réessayer. Veuillez contacter l’%sadministrateur du forum%s si vous continuez à rencontrer des problèmes.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Il n’a pas été possible de convertir votre mot de passe lors de la mise à jour de ce logiciel de forum. Vous pouvez demander un %snouveau mot de passe%s. Si vous continuez à rencontrer des problèmes, veuillez contacter l’%sadministrateur du forum%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Vous avez spécifié un nom d’utilisateur incorrect. Veuillez vérifier votre nom d’utilisateur et réessayer. Si vous continuez à rencontrer des problèmes, veuillez contacter l’%sadministrateur du forum%s.',
	'LOGIN_FORUM'						=> 'Pour consulter ou publier des messages dans ce forum, vous devez saisir son mot de passe.',
	'LOGIN_INFO'						=> 'Avant de pouvoir vous connecter, vous devez être inscrit. L’inscription prend seulement quelques secondes et vous offres de nombreux avantages. Par exemple, l’administrateur du forum peut accorder des permissions supplémentaires aux utilisateurs inscrits. Avant de vous inscrire, assurez-vous d’avoir pris connaissance de nos conditions d’utilisation et de notre politique de vie privée. Veuillez également vous assurer d’avoir consulté toutes les règles du forum.',
	'LOGIN_VIEWFORUM'					=> 'Vous devez vous inscrire et vous connecter afin de consulter ce forum.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Vous devez vous inscrire et vous connecter afin d’éditer les messages de ce forum.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Vous devez vous inscrire et vous connecter afin de consulter la liste des utilisateurs en ligne.',
	'LOGOUT'							=> 'Déconnexion',
	'LOGOUT_USER'						=> 'Déconnexion [ %s ]',
	'LOG_ME_IN'							=> 'Me connecter automatiquement lors de chaque visite',

	'MARK'					=> 'Cocher',
	'MARK_ALL'				=> 'Tout cocher',
	'MARK_FORUMS_READ'		=> 'Marquer les forums comme lus',
	'MB'					=> 'Mo',
	'MIB'					=> 'Mio',
	'MCP'					=> 'Panneau de contrôle du modérateur',
	'MEMBERLIST'			=> 'Membres',
	'MEMBERLIST_EXPLAIN'	=> 'Voir la liste complète des membres',
	'MERGE'					=> 'Fusionner',
	'MERGE_POSTS'			=> 'Fusionner les messages',
	'MERGE_TOPIC'			=> 'Fusionner le sujet',
	'MESSAGE'				=> 'Message',
	'MESSAGES'				=> 'Messages',
	'MESSAGE_BODY'			=> 'Corps du message',
	'MINUTES'				=> 'Minutes',
	'MODERATE'				=> 'Modérer',
	'MODERATOR'				=> 'Modérateur',
	'MODERATORS'			=> 'Modérateurs',
	'MONTH'					=> 'Mois',
	'MOVE'					=> 'Déplacer',
	'MSNM'					=> 'MSNM/WLM',	

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'Notre membre le plus récent est <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Nouveau message',
	'NEW_MESSAGES'				=> 'Nouveaux messages',
	'NEW_PM'					=> '<strong>%d</strong> nouveau message',
	'NEW_PMS'					=> '<strong>%d</strong> nouveaux messages',
	'NEW_POST'					=> 'Nouveau message',
	'NEW_POSTS'					=> 'Nouveaux messages',
	'NEXT'						=> 'Suivant',		// Used in pagination
	'NEXT_STEP'					=> 'Suivant',
	'NEVER'						=> 'Jamais',
	'NO'						=> 'Non',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Vous n’êtes pas autorisé à gérer ce groupe.',
	'NOT_AUTHORISED'			=> 'Vous n’êtes pas autorisé à accéder à cette zone.',
	'NOT_WATCHING_FORUM'		=> 'Vous n’êtes à présent plus abonné et ne recevrez plus les mises à jour de ce forum.',
	'NOT_WATCHING_TOPIC'		=> 'Vous n’êtes à présent plus abonné et ne recevrez plus les mises à jour de ce sujet.',
	'NOTIFY_ADMIN'				=> 'Veuillez avertir le webmestre ou un administrateur du forum.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Veuillez avertir le webmestre ou un administrateur du forum : <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Vous n’êtes pas autorisé à accéder à ce fichier.',
	'NO_ACTION'					=> 'Aucune action n’a été spécifiée.',
	'NO_ADMINISTRATORS'			=> 'Aucun administrateur n’est assigné à ce forum.',
	'NO_AUTH_ADMIN'				=> 'Vous n’êtes pas autorisé à accéder au panneau de contrôle de l’administrateur car vous n’avez pas les permissions appropriées.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Vous n’êtes pas autorisé à vous authentifier de nouveau avec un compte utilisateur différent du vôtre.',
	'NO_AUTH_OPERATION'			=> 'Vous n’avez pas les permissions appropriées afin d’accomplir cette opération.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Impossible de se connecter à l’hôte SMTP : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Il n’y a aucun anniversaire aujourd’hui',
	'NO_EMAIL_MESSAGE'			=> 'Le message e-mail est vide.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Impossible de récupérer les codes de réponses du serveur e-mail.',
	'NO_EMAIL_SUBJECT'			=> 'Vous n’avez spécifié aucun sujet pour l’e-mail.',
	'NO_FORUM'					=> 'Le forum que vous avez sélectionné n’existe pas.',
	'NO_FORUMS'					=> 'Aucun forum.',
	'NO_GROUP'					=> 'Le groupe d’utilisateurs spécifié n’existe pas.',
	'NO_GROUP_MEMBERS'			=> 'Ce groupe n’a actuellement aucun membre.',
	'NO_IPS_DEFINED'			=> 'Aucun nom d’hôte ou adresse IP n’a été défini',
	'NO_MEMBERS'				=> 'Aucun membre n’a été trouvé avec ce critère de recherche.',
	'NO_MESSAGES'				=> 'Aucun message',
	'NO_MODE'					=> 'Aucun mode n’a été spécifié.',
	'NO_MODERATORS'				=> 'Aucun modérateur n’est assigné à ce forum.',
	'NO_NEW_MESSAGES'			=> 'Aucun nouveau message',
	'NO_NEW_PM'					=> '<strong>0</strong> nouveau message',
	'NO_NEW_POSTS'				=> 'Aucun nouveau message',
	'NO_ONLINE_USERS'			=> 'Aucun utilisateur inscrit',
	'NO_POSTS'					=> 'Aucun message',
	'NO_POSTS_TIME_FRAME'		=> 'Aucun message n’existe dans ce sujet pour la période que vous avez spécifiée.',
	'NO_SUBJECT'				=> 'Aucun sujet n’a été spécifié',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Le format de stockage de la recherche que vous avez spécifié n’existe pas.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Aucune méthode d’authentification n’est supportée.',
	'NO_TOPIC'					=> 'Le sujet que vous avez spécifié n’existe pas.',
	'NO_TOPIC_FORUM'			=> 'Le sujet ou le forum que vous recherchez n’existe plus.',
	'NO_TOPICS'					=> 'Il n’y a aucun sujet ou message dans ce forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'Aucun sujet n’existe dans ce forum pour la période que vous avez spécifiée.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> message non-lu',
	'NO_UPLOAD_FORM_FOUND'		=> 'Le transfert a commencé mais aucun fichier transféré n’est correct.',
	'NO_USER'					=> 'L’utilisateur que vous avez spécifié n’existe pas.',
	'NO_USERS'					=> 'Les utilisateurs que vous avez spécifiés n’existent pas.',
	'NO_USER_SPECIFIED'			=> 'Aucun nom d’utilisateur n’a été spécifié.',

	'OCCUPATION'				=> 'Emploi',
	'OFFLINE'					=> 'Hors-ligne',
	'ONLINE'					=> 'En ligne',
	'ONLINE_BUDDIES'			=> 'Amis en ligne',
	'ONLINE_USERS_TOTAL'		=> 'Au total, il y a <strong>%d</strong> utilisateurs en ligne :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Au total, il y a <strong>0</strong> utilisateur en ligne :: ',
	'ONLINE_USER_TOTAL'			=> 'Au total, il y a <strong>%d</strong> utilisateur en ligne :: ',
	'OPTIONS'					=> 'Options',

	'PAGE_OF'				=> 'Page <strong>%1$d</strong> sur <strong>%2$d</strong>',
	'PASSWORD'				=> 'Mot de passe',
	'PLAY_QUICKTIME_FILE'	=> 'Lire le fichier Quicktime',
	'PM'					=> 'MP',
	'POSTING_MESSAGE'		=> 'Rédige un message dans %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Rédige un message privé',
	'POST'					=> 'Message',
	'POST_ANNOUNCEMENT'		=> 'Annonce',
	'POST_STICKY'			=> 'Note',
	'POSTED'				=> 'Publié',
	'POSTED_IN_FORUM'		=> 'dans',
	'POSTED_ON_DATE'		=> 'sur',
	'POSTS'					=> 'Messages',
	'POSTS_UNAPPROVED'		=> 'Au moins un message dans ce sujet n’a pas été approuvé.',
	'POST_BY_AUTHOR'		=> 'par',
	'POST_BY_FOE'			=> 'Ce message a été publié par <strong>%1$s</strong> qui est actuellement dans votre liste des utilisateurs ignorés. %2$sAfficher le message%3$s.',
	'POST_DAY'				=> '%.2f messages par jour',
	'POST_DETAILS'			=> 'Informations sur le message',
	'POST_NEW_TOPIC'		=> 'Publier un nouveau sujet',
	'POST_PCT'				=> '%.2f%% de tous les messages',
	'POST_PCT_ACTIVE'		=> '%.2f%% des messages de l’utilisateur',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% de vos messages',
	'POST_REPLY'			=> 'Publier une réponse',
	'POST_REPORTED'			=> 'Cliquez ici afin de consulter le rapport',
	'POST_SUBJECT'			=> 'Sujet du message',
	'POST_TIME'				=> 'Date du message',
	'POST_TOPIC'			=> 'Publier un nouveau sujet',
	'POST_UNAPPROVED'		=> 'Ce message est en attente d’approbation',
	'PREVIEW'				=> 'Aperçu',
	'PREVIOUS'				=> 'Précédent',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Précédent',
	'PRIVACY'				=> 'Politique de vie privée',
	'PRIVATE_MESSAGE'		=> 'Message privé',
	'PRIVATE_MESSAGES'		=> 'Messages privés',
	'PRIVATE_MESSAGING'		=> 'Messagerie privée',
	'PROFILE'				=> 'Panneau de contrôle de l’utilisateur',

	'READING_FORUM'				=> 'Consulte les sujets de %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Consulte une annonce globale',
	'READING_LINK'				=> 'Visite le forum-lien %s',
	'READING_TOPIC'				=> 'Consulte un sujet dans %s',
	'READ_PROFILE'				=> 'Profil',
	'REASON'					=> 'Raison',
	'RECORD_ONLINE_USERS'		=> 'Le nombre maximum d’utilisateurs en ligne simultanément a été de <strong>%1$s</strong> le %2$s',
	'REDIRECT'					=> 'Redirection',
	'REDIRECTS'					=> 'Nombre total de redirections',
	'REGISTER'					=> 'Inscription',
	'REGISTERED_USERS'			=> 'Utilisateurs inscrits :',
	'REG_USERS_ONLINE'			=> 'Il y a %d utilisateurs inscrits et ',
	'REG_USERS_TOTAL'			=> '%d inscrits, ',
	'REG_USERS_TOTAL_AND'		=> '%d inscrits et ',
	'REG_USERS_ZERO_ONLINE'		=> 'Il y a 0 utilisateur inscrit et ',
	'REG_USERS_ZERO_TOTAL'		=> '0 inscrit, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 inscrit et ',
	'REG_USER_ONLINE'			=> 'Il y a %d utilisateur inscrit et ',
	'REG_USER_TOTAL'			=> '%d inscrit, ',
	'REG_USER_TOTAL_AND'		=> '%d inscrit et ',
	'REMOVE'					=> 'Supprimer',
	'REMOVE_INSTALL'			=> 'Veuillez supprimer, déplacer ou renommer le répertoire d’installation avant d’utiliser votre forum. Tant que ce répertoire est présent, seul le panneau de contrôle de l’administrateur sera accessible.',
	'REPLIES'					=> 'Réponses',
	'REPLY_WITH_QUOTE'			=> 'Répondre en citant',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Répond à une annonce globale',
	'REPLYING_MESSAGE'			=> 'Répond à un message dans %s',
	'REPORT_BY'					=> 'Rapporté par',
	'REPORT_POST'				=> 'Rapporter ce message',
	'REPORTING_POST'			=> 'Rapporte un message',
	'RESEND_ACTIVATION'			=> 'Renvoyer l’e-mail d’activation',
	'RESET'						=> 'Réinitialiser',
	'RESTORE_PERMISSIONS'		=> 'Restaurer les permissions',
	'RETURN_INDEX'				=> '%sRetourner à la page d’index%s',
	'RETURN_FORUM'				=> '%sRetourner au dernier forum visité%s',
	'RETURN_PAGE'				=> '%sRetourner à la page précédente%s',
	'RETURN_TOPIC'				=> '%sRetourner au dernier sujet visité%s',
	'RETURN_TO'					=> 'Retourner vers',
	'RULES_ATTACH_CAN'			=> 'Vous <strong>pouvez</strong> insérer des pièces jointes dans ce forum',
	'RULES_ATTACH_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> insérer de pièces jointes dans ce forum',
	'RULES_DELETE_CAN'			=> 'Vous <strong>pouvez</strong> supprimer vos messages dans ce forum',
	'RULES_DELETE_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> supprimer vos messages dans ce forum',
	'RULES_DOWNLOAD_CAN'		=> 'Vous <strong>pouvez</strong> télécharger des pièces jointes dans ce forum',
	'RULES_DOWNLOAD_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> télécharger de pièces jointes dans ce forum',
	'RULES_EDIT_CAN'			=> 'Vous <strong>pouvez</strong> éditer vos messages dans ce forum',
	'RULES_EDIT_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> éditer vos messages dans ce forum',
	'RULES_LOCK_CAN'			=> 'Vous <strong>pouvez</strong> verrouiller vos messages dans ce forum',
	'RULES_LOCK_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> verrouiller vos messages dans ce forum',
	'RULES_POST_CAN'			=> 'Vous <strong>pouvez</strong> publier de nouveaux sujets dans ce forum',
	'RULES_POST_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> publier de nouveaux sujets dans ce forum',
	'RULES_REPLY_CAN'			=> 'Vous <strong>pouvez</strong> répondre aux sujets dans ce forum',
	'RULES_REPLY_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> répondre aux sujets dans ce forum',
	'RULES_VOTE_CAN'			=> 'Vous <strong>pouvez</strong> voter aux sondages dans ce forum',
	'RULES_VOTE_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> voter aux sondages dans ce forum',

	'SEARCH'					=> 'Rechercher',
	'SEARCH_MINI'				=> 'Rechercher…',
	'SEARCH_ADV'				=> 'Recherche avancée',
	'SEARCH_ADV_EXPLAIN'		=> 'Voir les options de la recherche avancée',
	'SEARCH_KEYWORDS'			=> 'Rechercher par mots-clés',
	'SEARCHING_FORUMS'			=> 'Rechercher dans les forums',
	'SEARCH_ACTIVE_TOPICS'		=> 'Voir les sujets actifs',
	'SEARCH_FOR'				=> 'Rechercher pour',
	'SEARCH_FORUM'				=> 'Rechercher dans ce forum…',	
	'SEARCH_NEW'				=> 'Voir les nouveaux messages',
	'SEARCH_POSTS_BY'			=> 'Rechercher les messages de',
	'SEARCH_SELF'				=> 'Voir vos messages',
	'SEARCH_TOPIC'				=> 'Rechercher dans ce sujet…',
	'SEARCH_UNANSWERED'			=> 'Voir les messages sans réponses',
	'SECONDS'					=> 'Secondes',
	'SELECT'					=> 'Sélectionner',
	'SELECT_ALL_CODE'			=> 'Tout sélectionner',
	'SELECT_DESTINATION_FORUM'	=> 'Veuillez sélectionner un forum de destination',
	'SELECT_FORUM'				=> 'Sélectionner un forum',
	'SEND_EMAIL'				=> 'Envoyer un e-mail',
	'SEND_EMAIL_USER'			=> 'Envoyer un e-mail à',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Envoyer un message privé',
	'SETTINGS'					=> 'Réglages',
	'SIGNATURE'					=> 'Signature',
	'SKIP'						=> 'Aller au contenu',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Le serveur SMTP ne supporte pas l’authentification.',
	'SORRY_AUTH_READ'			=> 'Vous n’êtes pas autorisé à consulter ce forum.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Vous n’êtes pas autorisé à télécharger cette pièce jointe.',
	'SORT_BY'					=> 'Trier par',
	'SORT_JOINED'				=> 'Date d’inscription',
	'SORT_LOCATION'				=> 'Localisation',
	'SORT_RANK'					=> 'Rang',
	'SORT_TOPIC_TITLE'			=> 'Titre du sujet',
	'SORT_USERNAME'				=> 'Nom d’utilisateur',
	'SPLIT_TOPIC'				=> 'Diviser le sujet',
	'SQL_ERROR_OCCURRED'		=> 'Une erreur SQL est survenue lors du chargement de la page. Veuillez contacter l’%sadministrateur du forum%s si ce problème persiste.',
	'STATISTICS'				=> 'Statistiques',
	'START_WATCHING_FORUM'		=> 'S’abonner au forum',
	'START_WATCHING_TOPIC'		=> 'S’abonner au sujet',
	'STOP_WATCHING_FORUM'		=> 'Se désabonner au forum',
	'STOP_WATCHING_TOPIC'		=> 'Se désabonner au sujet',
	'SUBFORUM'					=> 'Sous-forum',
	'SUBFORUMS'					=> 'Sous-forums',
	'SUBJECT'					=> 'Sujet',
	'SUBMIT'					=> 'Envoyer',

	'TERMS_USE'			=> 'Conditions d’utilisation',
	'TEST_CONNECTION'	=> 'Tester la connexion',
	'THE_TEAM'			=> 'L’équipe',
	'TIME'				=> 'Date',

	'TOO_LONG_AIM'					=> 'Le nom d’utilisateur AIM que vous avez spécifié est trop long.',
	'TOO_LONG_CONFIRM_CODE'			=> 'Le code de confirmation que vous avez spécifié est trop long.',
	'TOO_LONG_DATEFORMAT'			=> 'Le format de la date que vous avez spécifié est trop long.',
	'TOO_LONG_ICQ'					=> 'Le numéro ICQ que vous avez spécifié est trop long.',
	'TOO_LONG_INTERESTS'			=> 'Les loisirs que vous avez spécifiés sont trop longs.',
	'TOO_LONG_JABBER'				=> 'Le nom du compte Jabber que vous avez spécifié est trop long.',
	'TOO_LONG_LOCATION'				=> 'La localisation que vous avez spécifiée est trop longue.',
	'TOO_LONG_MSN'					=> 'Le nom d’utilisateur MSNM/WLM que vous avez spécifié est trop long.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Le mot de passe que vous avez spécifié est trop long.',
	'TOO_LONG_OCCUPATION'			=> 'L’emploi que vous avez spécifié est trop long.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Le mot de passe de confirmation que vous avez spécifié est trop long.',
	'TOO_LONG_USER_PASSWORD'		=> 'Le mot de passe que vous avez spécifié est trop long.',
	'TOO_LONG_USERNAME'				=> 'Le nom d’utilisateur que vous avez spécifié est trop long.',
	'TOO_LONG_EMAIL'				=> 'L’adresse e-mail que vous avez spécifiée est trop longue.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'L’adresse e-mail de confirmation que vous avez spécifiée est trop longue.',
	'TOO_LONG_WEBSITE'				=> 'L’adresse du site Internet que vous avez spécifiée est trop longue.',
	'TOO_LONG_YIM'					=> 'Le nom d’utilisateur Yahoo! Messenger que vous avez spécifié est trop long.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Vous avez voté pour un nombre trop important d’options.',

	'TOO_SHORT_AIM'					=> 'Le nom d’utilisateur AIM que vous avez spécifié est trop court.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'Le code de confirmation que vous avez spécifié est trop court.',
	'TOO_SHORT_DATEFORMAT'			=> 'Le format de la date que vous avez spécifié est trop court.',
	'TOO_SHORT_ICQ'					=> 'Le numéro ICQ que vous avez spécifié est trop court.',
	'TOO_SHORT_INTERESTS'			=> 'Les loisirs que vous avez spécifiés sont trop courts.',
	'TOO_SHORT_JABBER'				=> 'Le nom du compte Jabber que vous avez spécifié est trop court.',
	'TOO_SHORT_LOCATION'			=> 'La localisation que vous avez spécifiée est trop courte.',
	'TOO_SHORT_MSN'					=> 'Le nom d’utilisateur MSNM/WLM que vous avez spécifié est trop court.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Le mot de passe que vous avez spécifié est trop court.',
	'TOO_SHORT_OCCUPATION'			=> 'L’emploi que vous avez spécifié est trop court.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Le mot de passe de confirmation que vous avez spécifié est trop court.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Le mot de passe que vous avez spécifié est trop court.',
	'TOO_SHORT_USERNAME'			=> 'Le nom d’utilisateur que vous avez spécifié est trop court.',
	'TOO_SHORT_EMAIL'				=> 'L’adresse e-mail que vous avez spécifiée est trop courte.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'L’adresse e-mail de confirmation que vous avez spécifiée est trop courte.',
	'TOO_SHORT_WEBSITE'				=> 'L’adresse du site Internet que vous avez spécifiée est trop courte.',
	'TOO_SHORT_YIM'					=> 'Le nom d’utilisateur Yahoo! Messenger que vous avez spécifié est trop court.',

	'TOPIC'				=> 'Sujet',
	'TOPICS'			=> 'Sujets',
	'TOPIC_ICON'		=> 'Icône du sujet',
	'TOPIC_LOCKED'		=> 'Ce sujet est verrouillé, vous ne pouvez rédiger ou éditer aucun message.',
	'TOPIC_LOCKED_SHORT'=> 'Sujet verrouillé',
	'TOPIC_MOVED'		=> 'Sujet déplacé',
	'TOPIC_REVIEW'		=> 'Aperçu du sujet',
	'TOPIC_TITLE'		=> 'Titre du sujet',
	'TOPIC_UNAPPROVED'	=> 'Ce sujet n’a pas été approuvé',
	'TOTAL_ATTACHMENTS'	=> 'Pièce(s) jointe(s)',
	'TOTAL_LOG'			=> '1 historique',
	'TOTAL_LOGS'		=> '%d historiques',
	'TOTAL_NO_PM'		=> '<strong>0</strong> message privé au total',
	'TOTAL_PM'			=> '<strong>1</strong> message privé au total',
	'TOTAL_PMS'			=> '<strong>%d</strong> messages privés au total',
	'TOTAL_POSTS'		=> 'Total des messages',
	'TOTAL_POSTS_OTHER'	=> '<strong>%d</strong> messages au total',
	'TOTAL_POSTS_ZERO'	=> '<strong>0</strong> message au total',
	'TOPIC_REPORTED'	=> 'Ce sujet a été rapporté',
	'TOTAL_TOPICS_OTHER'=> '<strong>%d</strong> sujets au total',
	'TOTAL_TOPICS_ZERO'	=> '<strong>0</strong> sujet au total',
	'TOTAL_USERS_OTHER'	=> '<strong>%d</strong> membres au total',
	'TOTAL_USERS_ZERO'	=> '<strong>0</strong> membre au total',
	'TRACKED_PHP_ERROR'	=> 'Erreurs PHP survenues : %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Il n’a pas été possible de déterminer les dimensions de l’image.',
	'UNABLE_TO_DELIVER_FILE'=> 'Il n’a pas été possible de délivrer le fichier.',
	'UNKNOWN_BROWSER'		=> 'Navigateur inconnu',
	'UNMARK_ALL'			=> 'Tout décocher',
	'UNREAD_MESSAGES'		=> 'Messages non-lus',
	'UNREAD_PM'				=> '<strong>%d</strong> message non-lu',
	'UNREAD_PMS'			=> '<strong>%d</strong> messages non-lus',
	'UNWATCHED_FORUMS'			=> 'Vous n’êtes à présent plus abonné aux forums sélectionnés.',
	'UNWATCHED_TOPICS'			=> 'Vous n’êtes à présent plus abonné aux sujets sélectionnés.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Vous n’êtes à présent plus abonné aux entrées sélectionnées.',
	'UPDATE'				=> 'Mettre à jour',
	'UPLOAD_IN_PROGRESS'	=> 'Le transfert est en cours.',
	'URL_REDIRECT'			=> 'Si votre navigateur ne supporte pas les redirections automatiques, veuillez %scliquer ici%s afin d’être redirigé.',
	'USERGROUPS'			=> 'Groupes',
	'USERNAME'				=> 'Nom d’utilisateur',
	'USERNAMES'				=> 'Noms d’utilisateurs',
	'USER_AVATAR'			=> 'Avatar de l’utilisateur',
	'USER_CANNOT_READ'		=> 'Vous ne pouvez consulter aucun message dans ce forum.',
	'USER_POST'				=> '%d message',
	'USER_POSTS'			=> '%d messages',
	'USERS'					=> 'Utilisateurs',
	'USE_PERMISSIONS'		=> 'Tester les permissions de l’utilisateur',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Consulte',
	'VIEWING_FAQ'				=> 'Consulte la FAQ',
	'VIEWING_MEMBERS'			=> 'Consulte les informations d’un membre',
	'VIEWING_ONLINE'			=> 'Consulte la liste des utilisateurs en ligne',
	'VIEWING_MCP'				=> 'Consulte le panneau de contrôle du modérateur',
	'VIEWING_MEMBER_PROFILE'	=> 'Consulte le profil d’un membre',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Consulte ses messages privés',
	'VIEWING_REGISTER'			=> 'Inscrit un compte',
	'VIEWING_UCP'				=> 'Consulte le panneau de contrôle de l’utilisateur',
	'VIEWS'						=> 'Vus',
	'VIEW_BOOKMARKS'			=> 'Voir les favoris',
	'VIEW_FORUM_LOGS'			=> 'Voir les historiques',
	'VIEW_LATEST_POST'			=> 'Voir le dernier message',
	'VIEW_NEWEST_POST'			=> 'Voir le message non-lu le plus récent',
	'VIEW_NOTES'				=> 'Voir les notes de l’utilisateur',
	'VIEW_ONLINE_TIME'			=> 'basé sur les utilisateurs actifs de la %d dernière minute',
	'VIEW_ONLINE_TIMES'			=> 'basé sur les utilisateurs actifs des %d dernières minutes',
	'VIEW_TOPIC'				=> 'Voir le sujet',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Annonce : ',
	'VIEW_TOPIC_GLOBAL'			=> 'Annonce globale : ',
	'VIEW_TOPIC_LOCKED'			=> 'Verrouillé : ',
	'VIEW_TOPIC_LOGS'			=> 'Voir les historiques',
	'VIEW_TOPIC_MOVED'			=> 'Déplacé : ',
	'VIEW_TOPIC_POLL'			=> 'Sondage : ',
	'VIEW_TOPIC_STICKY'			=> 'Note : ',
	'VISIT_WEBSITE'				=> 'Visiter le site Internet',

	'WARNINGS'			=> 'Avertissements',
	'WARN_USER'			=> 'Avertir l’utilisateur',
	'WELCOME_SUBJECT'	=> 'Bienvenue sur les forums de %s',
	'WEBSITE'			=> 'Site Internet',
	'WHOIS'				=> 'Qui est-ce ?',
	'WHO_IS_ONLINE'		=> 'Qui est en ligne ?',
	'WRONG_PASSWORD'	=> 'Le mot de passe que vous avez spécifié est incorrect.',

	'WRONG_DATA_ICQ'			=> 'Le numéro ICQ que vous avez spécifié est incorrect.',
	'WRONG_DATA_JABBER'			=> 'Le nom du compte Jabber que vous avez spécifié est incorrect.',
	'WRONG_DATA_LANG'			=> 'La langue que vous avez spécifiée est incorrecte.',
	'WRONG_DATA_WEBSITE'		=> 'L’adresse du site Internet doit être un lien correct, incluant le protocole. Par exemple, http://www.example.com/.',
	'WROTE'						=> 'a écrit',

	'YEAR'				=> 'Année',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-JJ)',
	'YES'				=> 'Oui',
	'YIM'				=> 'YIM',	
	'YOU_LAST_VISIT'	=> 'Dernière visite le : %s',
	'YOU_NEW_PM'		=> 'Un nouveau message privé vous attend dans votre boîte de réception.',
	'YOU_NEW_PMS'		=> 'De nouveaux messages privés vous attendent dans votre boîte de réception.',
	'YOU_NO_NEW_PM'		=> 'Aucun nouveau message privé ne vous attend.',

	'datetime'			=> array(
		'TODAY'		=> 'Aujourd’hui',
		'TOMORROW'	=> 'Demain',
		'YESTERDAY'	=> 'Hier',

		'Sunday'	=> 'Dimanche',
		'Monday'	=> 'Lundi',
		'Tuesday'	=> 'Mardi',
		'Wednesday'	=> 'Mercredi',
		'Thursday'	=> 'Jeudi',
		'Friday'	=> 'Vendredi',
		'Saturday'	=> 'Samedi',

		'Sun'		=> 'Dim',
		'Mon'		=> 'Lun',
		'Tue'		=> 'Mar',
		'Wed'		=> 'Mer',
		'Thu'		=> 'Jeu',
		'Fri'		=> 'Ven',
		'Sat'		=> 'Sam',

		'January'	=> 'Janvier',
		'February'	=> 'Février',
		'March'		=> 'Mars',
		'April'		=> 'Avril',
		'May'		=> 'Mai',
		'June'		=> 'Juin',
		'July'		=> 'Juillet',
		'August'	=> 'Août',
		'September' => 'Septembre',
		'October'	=> 'Octobre',
		'November'	=> 'Novembre',
		'December'	=> 'Décembre',

		'Jan'		=> 'Jan',
		'Feb'		=> 'Fév',
		'Mar'		=> 'Mar',
		'Apr'		=> 'Avr',
		'May_short'	=> 'Mai',	// Short representation of "May". May_short used because in english the short and long date are the same for May.
		'Jun'		=> 'Juin',
		'Jul'		=> 'Juil',
		'Aug'		=> 'Aoû',
		'Sep'		=> 'Sep',
		'Oct'		=> 'Oct',
		'Nov'		=> 'Nov',
		'Dec'		=> 'Déc',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 heures',
		'-11'	=> 'UTC - 11 heures',
		'-10'	=> 'UTC - 10 heures',
		'-9.5'	=> 'UTC - 9:30 heures',
		'-9'	=> 'UTC - 9 heures',
		'-8'	=> 'UTC - 8 heures',
		'-7'	=> 'UTC - 7 heures',
		'-6'	=> 'UTC - 6 heures',
		'-5'	=> 'UTC - 5 heures',
		'-4'	=> 'UTC - 4 heures',
		'-3.5'	=> 'UTC - 3:30 heures',
		'-3'	=> 'UTC - 3 heures',
		'-2'	=> 'UTC - 2 heures',
		'-1'	=> 'UTC - 1 heure',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 heure',
		'2'		=> 'UTC + 2 heures',
		'3'		=> 'UTC + 3 heures',
		'3.5'	=> 'UTC + 3:30 heures',
		'4'		=> 'UTC + 4 heures',
		'4.5'	=> 'UTC + 4:30 heures',
		'5'		=> 'UTC + 5 heures',
		'5.5'	=> 'UTC + 5:30 heures',
		'5.75'	=> 'UTC + 5:45 heures',
		'6'		=> 'UTC + 6 heures',
		'6.5'	=> 'UTC + 6:30 heures',
		'7'		=> 'UTC + 7 heures',
		'8'		=> 'UTC + 8 heures',
		'8.75'	=> 'UTC + 8:45 heures',
		'9'		=> 'UTC + 9 heures',
		'9.5'	=> 'UTC + 9:30 heures',
		'10'	=> 'UTC + 10 heures',
		'10.5'	=> 'UTC + 10:30 heures',
		'11'	=> 'UTC + 11 heures',
		'11.5'	=> 'UTC + 11:30 heures',
		'12'	=> 'UTC + 12 heures',
		'12.75'	=> 'UTC + 12:45 heures',
		'13'	=> 'UTC + 13 heures',
		'14'	=> 'UTC + 14 heures',
		'dst'	=> '[ Heure d’été ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Île Baker',
		'-11'	=> '[UTC - 11] Niue, Samoa',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian, Île Cook',
		'-9.5'	=> '[UTC - 9:30] Îles Marquises',
		'-9'	=> '[UTC - 9] Alaska, Île Gambier',
		'-8'	=> '[UTC - 8] Pacifique',
		'-7'	=> '[UTC - 7] Montagnes Rocheuses',
		'-6'	=> '[UTC - 6] Centre',
		'-5'	=> '[UTC - 5] Est',
		'-4'	=> '[UTC - 4] Atlantique',
		'-3.5'	=> '[UTC - 3:30] Terre-Neuve',
		'-3'	=> '[UTC - 3] Amazonie, Groenland Central',
		'-2'	=> '[UTC - 2] Fernando de Noronha, Géorgie du Sud &amp; les Îles Sandwich du Sud',
		'-1'	=> '[UTC - 1] Açores, Cap-Vert, Groenland de l’Est',
		'0'		=> '[UTC] Europe de l’Ouest, Méridien de Greenwich',
		'1'		=> '[UTC + 1] Europe Centrale, Afrique de l’Ouest',
		'2'		=> '[UTC + 2] Europe de l’Est, Afrique Centrale',
		'3'		=> '[UTC + 3] Moscou, Afrique de l’Est',
		'3.5'	=> '[UTC + 3:30] Iran',
		'4'		=> '[UTC + 4] Gulf, Samara',
		'4.5'	=> '[UTC + 4:30] Afghanistan',
		'5'		=> '[UTC + 5] Pakistan, Iekaterinbourg',
		'5.5'	=> '[UTC + 5:30] Inde, Sri Lanka',
		'5.75'	=> '[UTC + 5:45] Népal',
		'6'		=> '[UTC + 6] Bangladesh, Bhoutan, Novosibirsk',
		'6.5'	=> '[UTC + 6:30] Îles Cocos, Myanmar',
		'7'		=> '[UTC + 7] Indochine, Krasnoyarsk',
		'8'		=> '[UTC + 8] Chine, Australie de l’Ouest, Irkutsk',
		'8.75'	=> '[UTC + 8:45] Australie du Sud-Est',
		'9'		=> '[UTC + 9] Japon, Corée, Chita',
		'9.5'	=> '[UTC + 9:30] Australie Centrale',
		'10'	=> '[UTC + 10] Australie de l’Est, Vladivostok',
		'10.5'	=> '[UTC + 10:30] Lord Howe',
		'11'	=> '[UTC + 11] Île Solomon, Magadan',
		'11.5'	=> '[UTC + 11:30] Île Norfolk',
		'12'	=> '[UTC + 12] Nouvelle Zélande, Fiji, Kamchatka',
		'12.75'	=> '[UTC + 12:45] Îles Chatham',
		'13'	=> '[UTC + 13] Tongo, Îles Phoenix',
		'14'	=> '[UTC + 14] Île de Wight',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1er, ’07, 13:37',
		'D M d, Y g:i a'		=> 'Lun Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'Janvier 1er, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Aujourd’hui, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Aujourd’hui, 1:37 pm / Janvier 1er, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D j M Y, H:i', // Mon Jan 01, 2007 1:37 pm

));

?>
